<?php

namespace MSML\HttpClient\Accessories;

use Sentry\Event;
use Sentry\EventHint;

class Sentry
{
    /**
     * Execute checks and operations before sending the event to Sentry.
     */
    public static function beforeSend(Event $event, EventHint|null $hint): Event|null
    {
        if (!$hint) {
            return $event;
        }

        $exception = $hint->exception;

        // Don't report exceptions that are marked as non-reportable.
        if (property_exists($exception, 'report') && data_get($exception, 'report') === false) {
            return null;
        }

        // Enrich the Sentry error with provided contexts.
        if (property_exists($exception, 'contexts') && !empty(data_get($exception, 'contexts'))) {
            foreach ($exception->contexts as $name => $data) {
                $event->setContext($name, $data);
            }
        }

        return $event;
    }
}
