<?php

namespace MSML\HttpClient\Accessories;

use MSML\HttpClient\Exceptions\BrokenXMLStringException;

class XML
{
    /**
     * Converts an XML string to an associative array.
     */
    public static function toArray(string $xmlString, bool $throw = true): array|null
    {
        libxml_use_internal_errors(true);

        $xmlObject = simplexml_load_string($xmlString);

        if ($xmlObject === false) {
            if ($throw) {
                throw new BrokenXMLStringException('XML String could not be parsed.');
            }

            return null;
        }

        libxml_use_internal_errors(false);

        return json_decode(json_encode($xmlObject), true);
    }
}
