<?php

namespace MSML\HttpClient\Command;

use Illuminate\Console\Command;
use Prometheus\CollectorRegistry;

class PurgePrometheusMetrics extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'http-client:purge-prometheus-metrics';

    /**
     * The console command description.
     */
    protected $description = 'Purge all metrics for the Prometheus collector.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        CollectorRegistry::getDefault()->wipeStorage();
        $this->info('All metrics have been purged.');
    }
}
