<?php

namespace MSML\HttpClient;

use Spatie\LaravelPackageTools\Package;
use MSML\HttpClient\Command\PurgePrometheusMetrics;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class HttpClientServiceProvider extends PackageServiceProvider
{
    /**
     * Configure the package service provider.
     */
    public function configurePackage(Package $package): void
    {
        $package
            ->name('http-client')
            ->hasConfigFile()
            ->hasCommand(PurgePrometheusMetrics::class);
    }

    /**
     * Boot the package service provider.
     */
    public function bootingPackage(): void
    {
        if (config('http-client.prometheus.enabled')) {
            $this->package->hasRoute('web');
        }
    }
}
