<?php

namespace MSML\HttpClient\Middleware;

use GuzzleHttp\Middleware;
use GuzzleHttp\Promise\Promise;
use Prometheus\CollectorRegistry;
use Psr\Http\Message\RequestInterface;
use GuzzleHttp\Promise\RejectedPromise;
use Psr\Http\Message\ResponseInterface;

class PrometheusClientMiddleware
{
    /**
     * Handle an incoming response.
     */
    public static function prometheus(): callable
    {
        if (!config('http-client.prometheus.enabled')) {
            return fn ($handler) => $handler;
        }

        return Middleware::tap(null, function (RequestInterface $request, array $options, Promise|RejectedPromise $response) {
            $response->then(
                onFulfilled: function (ResponseInterface $response) use ($request) {
                    if ($response->getStatusCode() >= 500) {
                        $counter = CollectorRegistry::getDefault()->getOrRegisterCounter(
                            'laravel_http_client',
                            'server_errors',
                            'Amount of server errors',
                            ['environment', 'app', 'host']
                        );

                        $counter->inc([
                            'environment' => strtolower(config('app.env')),
                            'app'         => strtolower(config('app.name')),
                            'host'        => $request->getUri()->getHost(),
                        ]);
                    }
                },

                onRejected: function (\Throwable $e) use ($request) {
                    if ($e instanceof \GuzzleHttp\Exception\ConnectException && $e->getHandlerContext()['errno'] === 28) {
                        $counter = CollectorRegistry::getDefault()->getOrRegisterCounter(
                            'laravel_http_client',
                            'server_timeouts',
                            'Amount of timeouts',
                            ['environment', 'app', 'host']
                        );

                        $counter->inc([
                            'environment' => strtolower(config('app.env')),
                            'app'         => strtolower(config('app.name')),
                            'host'        => $request->getUri()->getHost(),
                        ]);
                    }
                }
            );
        });
    }
}
