<?php

namespace MSML\HttpClient\Exceptions;

use Exception;

class HttpClientException extends Exception
{
    /**
     * The HTTP status code returned by the client.
     */
    public int|null $httpStatusCode = null;

    /**
     * Indicate whether this exception should be reported.
     */
    public bool $report = true;

    /**
     * The extra contexts that should be reported along with the exception.
     */
    public array $contexts = [];

    /**
     * Don't report this exception to sentry.
     */
    public function dontReport(): self
    {
        $this->report = false;

        return $this;
    }

    /**
     * Enrich the exception with an extra context.
     */
    public function setContext(string $name, array $data): self
    {
        if (!empty($data)) {
            $this->contexts[$name] = $data;
        }

        return $this;
    }
}
