<?php

namespace MSML\HttpClient;

use Prometheus\Storage\Redis;
use Spatie\LaravelPackageTools\Package;
use MSML\HttpClient\Command\PurgePrometheusMetrics;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class HttpClientServiceProvider extends PackageServiceProvider
{
    /**
     * Configure the package service provider.
     */
    public function configurePackage(Package $package): void
    {
        $package
            ->name('http-client')
            ->hasConfigFile()
            ->hasCommand(PurgePrometheusMetrics::class);
    }

    /**
     * Boot the package service provider.
     */
    public function bootingPackage(): void
    {
        if (config('http-client.prometheus.enabled')) {
            $this->package->hasRoute('web');

            Redis::setDefaultOptions([
                'host'                   => config('http-client.prometheus.redis.host'),
                'port'                   => config('http-client.prometheus.redis.port'),
                'password'               => config('http-client.prometheus.redis.password'),
                'timeout'                => config('http-client.prometheus.redis.timeout'),
                'read_timeout'           => config('http-client.prometheus.redis.read_timeout'),
                'persistent_connections' => config('http-client.prometheus.redis.persistent_connections'),
            ]);
        }
    }
}
