<?php

declare(strict_types=1);

namespace MSML\AppVersion\Models;

use Illuminate\Support\Carbon;
use MSML\AppVersion\Enums\AppTypeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Attributes\Scope;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property string $name
 * @property string $identifier
 * @property AppTypeEnum $type
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \MSML\AppVersion\Models\AppVersion|Model> $appVersions
 *
 * @method static Builder<App> internal()
 */
class App extends Model
{
    /**
     * @var list<string>
     */
    protected $guarded = [];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'type' => AppTypeEnum::class,
        ];
    }

    /**
     * @return HasMany<AppVersion|Model, $this>
     */
    public function appVersions(): HasMany
    {
        return $this->hasMany(config('app-version.models.app_version'));
    }

    #[Scope]
    protected function internal(Builder $query): void
    {
        $query->where('type', AppTypeEnum::Internal);
    }
}
