<?php

declare(strict_types=1);

namespace MSML\AppVersion\Models;

use Illuminate\Support\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use MSML\AppVersion\Enums\MobileAppTypeEnum;
use Illuminate\Database\Eloquent\Attributes\Scope;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property string $name
 * @property string $identifier
 * @property MobileAppTypeEnum $type
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \MSML\AppVersion\Models\MobileAppVersion|Model> $appVersions
 *
 * @method static Builder<MobileApp> inHouse()
 */
class MobileApp extends Model
{
    /**
     * @var list<string>
     */
    protected $guarded = [];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'type' => MobileAppTypeEnum::class,
        ];
    }

    /**
     * @return HasMany<MobileAppVersion|Model, $this>
     */
    public function mobileAppVersions(): HasMany
    {
        return $this->hasMany(config('app-version.models.mobile_app_version'));
    }

    #[Scope]
    protected function inHouse(Builder $query): void
    {
        $query->where('type', MobileAppTypeEnum::InHouse);
    }

    #[Scope]
    protected function store(Builder $query): void
    {
        $query->where('type', MobileAppTypeEnum::Store);
    }
}
