<?php

declare(strict_types=1);

namespace MSML\AppVersion\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use MSML\AppVersion\Models\App;

/**
 * @extends Factory<App>
 */
class AppFactory extends Factory
{
    /**
     * @var class-string<App>
     */
    protected $model = App::class;

    public function definition(): array
    {
        return [
            'name'    => fake()->company(),
            'keyname' => fake()->unique()->slug(2),
        ];
    }

    public function primer(): static
    {
        return $this->state(['name' => 'Primer', 'keyname' => 'primer']);
    }

    public function primerStg(): static
    {
        return $this->state(['name' => 'Primer-STG', 'keyname' => 'primer-stg']);
    }
}
