<?php

declare(strict_types=1);

namespace MSML\AppVersion\Database\Factories;

use MSML\AppVersion\Models\AppVersion;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Foundation\Auth\User;
use MSML\AppVersion\Models\App;

/**
 * @extends Factory<AppVersion>
 */
class AppVersionFactory extends Factory
{
    /**
     * @var class-string<AppVersion>
     */
    protected $model = AppVersion::class;

    public function definition(): array
    {
        $major = fake()->numberBetween(0, 2);
        $minor = fake()->numberBetween(0, 10);
        $patch = fake()->numberBetween(0, 200);

        return [
            'app_id'       => App::factory(),
            'version'      => "{$major}.{$minor}.{$patch}",
            'platform'     => fake()->randomElement(['ios', 'android']),
            'url'          => fake()->url(),
            'text'         => fake()->sentence(),
            'force_update' => fake()->boolean(10),
            'user_id'      => User::inRandomOrder()->first()?->id,
            'published_at' => fake()->optional(0.8)->dateTimeBetween('-6 months'),
        ];
    }

    public function published(): static
    {
        return $this->state(['published_at' => now()->subDays(fake()->numberBetween(1, 30))]);
    }

    public function unpublished(): static
    {
        return $this->state(['published_at' => null]);
    }

    public function forceUpdate(): static
    {
        return $this->state(['force_update' => true]);
    }
}
