<?php

declare(strict_types=1);

namespace MSML\AppVersion\Actions;

use MSML\AppVersion\Models\App;
use MSML\AppVersion\Models\AppVersion;

class CheckAppVersion
{
    /**
     * @return array<string, string|null|bool>
     */
    public function handle(string $appKeyname, string $platform, string $version): array
    {
        $app = App::where('keyname', $appKeyname)->first();

        if (!$app) {
            return [
                'allowed' => false,
                'force'   => false,
                'message' => 'App not found',
                'latest'  => null,
                'url'     => null,
            ];
        }

        $required = AppVersion::query()
            ->where('app_id', $app->id)
            ->where('platform', $platform)
            ->whereNotNull('published_at')
            ->latest('published_at')
            ->first();

        if (is_null($required)) {
            return [
                'allowed' => true,
                'force' => false,
                'message' => null,
                'latest'  => null,
                'url'     => null,
            ];
        }

        $allowed = version_compare($version, $required->version, '>=');
        $force = $required->force_update || !$allowed;

        return [
            'allowed' => $allowed,
            'force'   => $force,
            'message' => $force
                ? ($required->text ?? config('app-version.messages.force_update_required'))
                : ($required->text ?? config('app-version.messages.update_required')),
            'latest' => $required->version,
            'url'    => $required->url,
        ];
    }
}
