<?php

declare(strict_types=1);

namespace MSML\AppVersion;

use Spatie\LaravelPackageTools\Package;
use MSML\AppVersion\Http\Middleware\EnforceAppVersion;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class AppVersionServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('laravel-app-version')
            ->hasConfigFile('app-version')
            ->hasMigration('create_apps_table')
            ->hasMigration('create_app_versions_table')
            ->hasMigration('update_app_versions_table');
    }

    public function bootingPackage(): void
    {
        $this->app['router']->aliasMiddleware('enforce.app.version', EnforceAppVersion::class);
    }
}
