<?php

declare(strict_types=1);

namespace MSML\AppVersion\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use MSML\AppVersion\Actions\CheckAppVersion;
use Symfony\Component\HttpFoundation\Response;

class EnforceAppVersion
{
    public function __construct(private CheckAppVersion $check) {}

    public function handle(Request $request, Closure $next): Response
    {
        $versionHeader = config('app-version.headers.version', 'X-App-Version');
        $platformHeader = config('app-version.headers.platform', 'X-App-Platform');
        $appHeader = config('app-version.headers.app', 'X-App-Keyname');

        $clientVersion = $request->headers->get($versionHeader);
        $platformRaw = $request->headers->get($platformHeader);
        $appKeyname = $request->headers->get($appHeader);

        if (!is_string($clientVersion) || $clientVersion === '' || !is_string($platformRaw) || $platformRaw === '' || !is_string($appKeyname) || $appKeyname === '') {
            return response()->json([
                'message'          => config('app-version.messages.missing_headers'),
                'required_headers' => [$versionHeader, $platformHeader, $appHeader],
            ], 400);
        }

        $platform = strtolower($platformRaw);
        if (!in_array($platform, ['ios', 'android'], true)) {
            return response()->json([
                'message'          => config('app-version.messages.missing_headers'),
                'required_headers' => [$versionHeader, $platformHeader, $appHeader],
            ], 400);
        }

        $result = $this->check->handle($appKeyname, $platform, $clientVersion);

        if (!$result['allowed']) {
            return response()->json($result + ['force' => true], 426);
        }

        return $next($request);
    }
}
