<?php

declare(strict_types=1);

namespace MSML\AppVersion\Models;

use Illuminate\Support\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use MSML\AppVersion\Models\AppVersion;

/**
 * @property int $id
 * @property string $name
 * @property string $keyname
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class App extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * @var list<string>
     */
    protected $guarded = [];

    /**
     * @return HasMany<AppVersion, $this>
     */
    public function appVersions(): HasMany
    {
        return $this->hasMany(AppVersion::class);
    }
}
