<?php

declare(strict_types=1);

namespace MSML\AppVersion\Database\Factories;

use MSML\AppVersion\Models\AppVersion;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<AppVersion>
 */
class AppVersionFactory extends Factory
{
    /**
     * @var class-string<AppVersion>
     */
    protected $model = AppVersion::class;

    public function definition(): array
    {
        return [
            'version'  => implode('.', [$this->faker->numberBetween(1, 3), $this->faker->numberBetween(0, 9), $this->faker->numberBetween(0, 9)]),
            'text'     => 'Update required.',
            'platform' => $this->faker->randomElement(['ios', 'android']),
            'user_id'  => null,
        ];
    }
}
