# Laravel App Version

A lightweight Laravel package to centrally manage mobile app versions for iOS and Android and enforce update policies through middleware and actions.

## Features

* Minimum and latest versions per platform
* Forced updates with middleware that blocks outdated clients
* Version check action to verify if a version is supported
* Configurable messages from the database or config fallback
* Database backed via migrations and factories

## Installation

Install via Composer:

```bash
composer require msml/laravel-app-version
```

Publish and run the migrations:

```bash
php artisan vendor:publish --tag="app-version-migrations"
php artisan migrate
```

Publish the config:

```bash
php artisan vendor:publish --tag="app-version-config"
```

Published config:

```php
return [
    'messages' => [
        'update_required' => 'Please update your app to continue.',
    ],
];
```

## Usage

### Middleware

Protect endpoints with the middleware to enforce version rules:

```php
Route::middleware(['enforce.app.version'])->group(function () {
    Route::get('/secure-endpoint', fn () => 'ok');
});
```

Clients that are too old receive a **426 Upgrade Required** response:

```json
{
  "allowed": false,
  "message": "Force update to 3.1.0.",
  "latest": "3.1.0"
}
```

### Action

Use the `CheckAppVersion` action directly with its `handle` method:

```php
use MSML\AppVersion\Actions\CheckAppVersion;

/** @var \MSML\AppVersion\Actions\CheckAppVersion $checker */
$checker = app(CheckAppVersion::class);

$result = $checker->handle('android', '3.0.0');

// $result = [
//   'allowed' => false,
//   'message' => 'Force update to 3.1.0.',
//   'latest'  => '3.1.0',
// ];
```

### Model

Create or update versions in the `app_versions` table:

```php
use MSML\AppVersion\Models\MobileAppVersion;

MobileAppVersion::create([
    'platform' => 'android',
    'version'  => '3.1.0',
    'text'     => 'Force update to 3.1.0.',
]);
```

## Testing

```bash
composer test
```

## Credits

* [MSML](https://github.com/msmlbv)
* All contributors

## License

The MIT License (MIT). See [LICENSE.md](LICENSE.md) for details.
