<?php

declare(strict_types=1);

namespace MSML\AppVersion\Rules;

use Illuminate\Contracts\Validation\ValidationRule;
use MSML\AppVersion\Enums\MobileAppVersionPlatformEnum;

class PlatformRule implements ValidationRule
{
    public function validate(string $attribute, mixed $value, \Closure $fail): void
    {
        $enum = is_string($value) ? MobileAppVersionPlatformEnum::tryFrom(strtolower($value)) : null;

        if (!$enum) {
            $fail('The :attribute must be a valid platform (ios or android).');
        }
    }
}
