<?php

namespace MSML\AppVersion\Database\Factories;

use MSML\AppVersion\Models\AppVersion;
use Illuminate\Database\Eloquent\Factories\Factory;

class AppVersionFactory extends Factory
{
    protected $model = AppVersion::class;

    public function definition(): array
    {
        return [
            'version'  => implode('.', [$this->faker->numberBetween(1, 3), $this->faker->numberBetween(0, 9), $this->faker->numberBetween(0, 9)]),
            'text'     => 'Update required.',
            'platform' => $this->faker->randomElement(['ios', 'android']),
            'user_id'  => null,
        ];
    }
}
