<?php

namespace MSML\AppVersion\Actions;

use MSML\AppVersion\Models\AppVersion;

class CheckAppVersion
{
    /**
     * @return array{allowed:bool,message:string|null,latest:string|null}
     */
    public function handle(string $platform, string $version): array
    {
        $required = AppVersion::query()
            ->where('platform', $platform)
            ->latest('created_at')
            ->first();

        if (is_null($required)) {
            return [
                'allowed' => true,
                'message' => null,
                'latest'  => null,
            ];
        }

        $allowed = version_compare($version, $required->version, '>=');

        return [
            'allowed' => $allowed,
            'message' => $required->text ?? config('app-version.messages.update_required'),
            'latest'  => $required->version,
        ];
    }
}
