<?php

namespace MSML\AppVersion\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use MSML\AppVersion\Actions\CheckAppVersion;

class EnforceAppVersion
{
    public function __construct(private CheckAppVersion $check) {}

    public function handle(Request $request, Closure $next)
    {
        $versionHeader = config('app-version.headers.version', 'X-App-Version');
        $platformHeader = config('app-version.headers.platform', 'X-App-Platform');

        $clientVersion = $request->headers->get($versionHeader);
        $platformRaw = $request->headers->get($platformHeader);

        if (!is_string($clientVersion) || $clientVersion === '' || !is_string($platformRaw) || $platformRaw === '') {
            return response()->json([
                'message'          => config('app-version.messages.missing_headers'),
                'required_headers' => [$versionHeader, $platformHeader],
            ], 400);
        }

        $platform = strtolower($platformRaw);
        if (!in_array($platform, ['ios', 'android'], true)) {
            return response()->json([
                'message'          => config('app-version.messages.missing_headers'),
                'required_headers' => [$versionHeader, $platformHeader],
            ], 400);
        }

        $result = $this->check->handle($platform, $clientVersion);

        if (!$result['allowed']) {
            return response()->json($result + ['force' => true], 426);
        }

        return $next($request);
    }
}
