<?php

namespace MSML\AppVersion\Rules;

use MSML\AppVersion\Enums\AppVersionPlatformEnum;
use Illuminate\Contracts\Validation\ValidationRule;

class PlatformRule implements ValidationRule
{
    public function validate(string $attribute, mixed $value, \Closure $fail): void
    {
        $enum = is_string($value) ? AppVersionPlatformEnum::tryFrom(strtolower($value)) : null;

        if (!$enum) {
            $fail('The :attribute must be a valid platform (ios or android).');
        }
    }
}
