<?php

namespace MSML\AppVersion\Rules;

use MSML\AppVersion\Models\AppVersion;
use Illuminate\Contracts\Validation\ValidationRule;

class VersionRule implements ValidationRule
{
    public function __construct(
        private $platform,
        private $ignoreId = null
    ) {}

    public function validate(string $attribute, mixed $value, \Closure $fail): void
    {
        if (
            !is_string($value)
            || !preg_match(
                '/^(?P<Major>0|(?:[1-9]\d*))(?:\.(?P<Minor>0|(?:[1-9]\d*))(?:\.(?P<Patch>0|(?:[1-9]\d*)))?(?:\-(?P<PreRelease>[0-9A-Z\.-]+))?(?:\+(?P<Meta>[0-9A-Z\.-]+))?)?$/i',
                $value
            )
        ) {
            $fail('The :attribute must be a valid version (e.g. 1.2.3, 1.2.3-beta, 1.2.3+build).');
            return;
        }

        $platform = strtolower((string)$this->platform);

        $query = AppVersion::query()
            ->where('platform', $platform)
            ->where('version', $value);

        if ($this->ignoreId !== null) {
            $query->whereKeyNot($this->ignoreId);
        }

        if ($query->exists()) {
            $fail('This version already exists for the selected platform.');
        }
    }
}
