<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Nodes\NumberNode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithVariant;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasNumericValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithNumberFormat;
use MSML\Blueprint\DSL\Traits\Specialized\WithNumericBounds;

final class NumberBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasNumericValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithDisabled;
    use WithHelp;
    use WithNumberFormat;
    use WithNumericBounds;
    use WithPlaceholder;
    use WithRules;
    use WithSize;
    use WithVariant;

    protected NumberNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;
        $this->node = new NumberNode(
            label: $label,
            span: 12,
            min: null,
            max: null,
            precision: null,
            step: null,
            placeholder: null,
            help: null,
            size: Size::SM,
            variant: Variant::Default,
            disabled: false,
            allowNegative: true,
            allowDecimal: true,
            prefix: null,
            suffix: null,
            clampBehavior: null,
            hideControls: false,
            thousandSeparator: null,
            fixedDecimalScale: false,
            decimalScale: null
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
