<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Enums\HorizontalPosition;

final class SelectNode extends FieldNode
{
    /**
     * @param  list<string|array{label:string,value:mixed}>|null  $options
     */
    public function __construct(
        public readonly string|null $label,
        public readonly array|null $options = null,
        public readonly int $span = 12,
        public readonly string|null $placeholder = null,
        public readonly bool $multiple = false,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $searchable = false,
        public readonly bool $clearable = false,
        public readonly int|null $limit = null,
        public readonly string|null $nothingFoundMessage = null,
        public readonly bool $withCheckIcon = true,
        public readonly HorizontalPosition $checkIconPosition = HorizontalPosition::Left,
        public readonly bool $allowDeselect = true,
        public readonly bool $selectFirstOptionOnChange = false,
    ) {
        parent::__construct('Select');
    }
}
