<?php

namespace MSML\Blueprint\Support;

use MSML\Blueprint\Contracts\Blueprint;

final class BlueprintResolver
{
    /**
     * @param  array<string, class-string<Blueprint>|Blueprint>  $blueprints
     */
    public function __construct(private array $blueprints = []) {}

    /**
     * @return array<string, class-string<Blueprint>|Blueprint>
     */
    public function all(): array
    {
        return $this->blueprints;
    }

    /**
     * @return class-string<Blueprint>|Blueprint|null
     */
    public function get(string $key): Blueprint|string|null
    {
        return $this->blueprints[$key] ?? null;
    }

    /**
     * @return array<int,array{key:string,class:string}>
     */
    public function list(): array
    {
        $out = [];
        foreach ($this->blueprints as $key => $class) {
            $out[] = [
                'key'   => $key,
                'class' => is_string($class) ? $class : get_class($class),
            ];
        }

        return $out;
    }
}
