# Laravel Blueprint

Laravel Blueprint is a focused package that provides a fluent DSL (Domain Specific Language) for building UI form specifications. The package is designed to be **consumer-agnostic** - it only handles blueprint building and specification generation, leaving implementation details to the consumer.

## Documentation

### Getting Started
1. [Introduction](docs/01-introduction.md) - Package overview and core concepts
2. [Getting Started](docs/02-getting-started.md) - Setup and your first blueprint

### Core Features
3. [Special Components](docs/03-special-components.md) - Autocomplete, tags, file uploads, rich text
4. [Layout and Composition](docs/04-layout-and-composition.md) - Tabs, rows, panels, and nesting
5. [Validation and Data](docs/05-validation-and-data.md) - Validation rules and data injection

### Advanced Usage
6. [Component Overrides](docs/06-component-overrides.md) - Building custom renderers
7. [Advanced Patterns](docs/07-advanced-patterns.md) - Conditional fields, reusable helpers
8. [Slots](docs/08-slots.md) - Custom React components with type safety


## Package Architecture

Laravel Blueprint follows a **Tab-Based Recursive DSL** architecture:

```
Blueprint → Tab → Row → Element(Component|Row) [recursive]
```
