<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Schema;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Attributes\Computed;

abstract class ElementSchema extends Data
{
    #[Computed]
    public string $type;

    public function __construct(
        public int $span = 12,
    ) {
        $this->type = $this->getType();
    }

    abstract public function getType(): string;
}
