<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Common;

use MSML\Blueprint\DSL\Enums\Variant;

trait WithVariant
{
    public function variant(Variant $variant): self
    {
        $this->updateNodeWith(['variant' => $variant]);

        return $this;
    }

    public function variantDefualt(): self
    {
        $this->updateNodeWith(['variant' => Variant::Default]);

        return $this;
    }

    public function variantFilled(): self
    {
        $this->updateNodeWith(['variant' => Variant::Filled]);

        return $this;
    }

    public function variantUnstyled(): self
    {
        $this->updateNodeWith(['variant' => Variant::Unstyled]);

        return $this;
    }
}
