<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithFrequencyRules
{
    /** @param  list<string>  $rules */
    public function rulesFor(string $key, array $rules): self
    {
        $existingRules = $this->root->rules[$key] ?? [];
        $this->root->rules[$key] = array_merge($existingRules, $rules);

        return $this;
    }

    public function required(): self
    {
        $rulesValue = $this->root->rules[$this->node->valueKey] ?? [];

        $rulesValue = $this->excludeNullable($rulesValue);

        $this->root->rules[$this->node->valueKey] = $rulesValue;

        $rulesUnit = $this->root->rules[$this->node->unitKey] ?? [];

        $rulesUnit = $this->excludeNullable($rulesUnit);

        $this->root->rules[$this->node->unitKey] = $rulesUnit;

        return $this;
    }

    public function nullable(): self
    {
        $rulesValue = $this->root->rules[$this->node->valueKey] ?? [];

        $rulesValue = $this->excludeRequired($rulesValue);

        $this->root->rules[$this->node->valueKey] = $rulesValue;

        $rulesUnit = $this->root->rules[$this->node->unitKey] ?? [];

        $rulesUnit = $this->excludeRequired($rulesUnit);

        $this->root->rules[$this->node->unitKey] = $rulesUnit;

        return $this;
    }

    /**
     * @param  list<string>  $rules
     * @return list<string>
     */
    private function excludeNullable(array $rules): array
    {
        $rules = array_values(array_filter($rules, fn (string $r) => $r !== 'nullable'));

        array_unshift($rules, 'required');

        return $rules;
    }

    /**
     * @param  list<string>  $rules
     * @return list<string>
     */
    private function excludeRequired(array $rules): array
    {
        if (!in_array('required', $rules, true)) {
            $rules = array_values(array_filter($rules, fn ($r) => $r !== 'nullable'));
            array_unshift($rules, 'nullable');
        }

        return $rules;
    }
}
