<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithTextEditor
{
    /**
     * @param  list<string>  $toolbar
     */
    public function toolbar(array $toolbar): self
    {
        $this->updateNodeWith(['toolbar' => $toolbar]);

        return $this;
    }

    public function withBold(): self
    {
        $this->addToolbarItem('bold');

        return $this;
    }

    public function withItalic(): self
    {
        $this->addToolbarItem('italic');

        return $this;
    }

    public function withUnderline(): self
    {
        $this->addToolbarItem('underline');

        return $this;
    }

    public function withStrikethrough(): self
    {
        $this->addToolbarItem('strikethrough');

        return $this;
    }

    public function withH1(): self
    {
        $this->addToolbarItem('h1');

        return $this;
    }

    public function withH2(): self
    {
        $this->addToolbarItem('h2');

        return $this;
    }

    public function withH3(): self
    {
        $this->addToolbarItem('h3');

        return $this;
    }

    public function withBulletList(): self
    {
        $this->addToolbarItem('bulletList');

        return $this;
    }

    public function withOrderedList(): self
    {
        $this->addToolbarItem('orderedList');

        return $this;
    }

    public function withLink(): self
    {
        $this->addToolbarItem('link');

        return $this;
    }

    public function withUnlink(): self
    {
        $this->addToolbarItem('unlink');

        return $this;
    }

    public function withImage(): self
    {
        $this->addToolbarItem('image');

        return $this;
    }

    public function maxLength(int $maxLength): self
    {
        $this->updateNodeWith(['maxLength' => $maxLength]);

        return $this;
    }

    private function addToolbarItem(string $item): void
    {
        $currentToolbar = $this->node->toolbar ?? [];
        $currentToolbar[] = $item;
        $this->updateNodeWith(['toolbar' => $currentToolbar]);
    }
}
