<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithTimeBounds
{
    public function format(string $format): self
    {
        $this->updateNodeWith(['format' => $format]);

        return $this;
    }

    public function format12h(): self
    {
        $this->updateNodeWith(['format' => '12h']);

        return $this;
    }

    public function format24h(): self
    {
        $this->updateNodeWith(['format' => '24h']);

        return $this;
    }

    public function minTime(string $minTime): self
    {
        $this->updateNodeWith(['minTime' => $minTime]);

        return $this;
    }

    public function maxTime(string $maxTime): self
    {
        $this->updateNodeWith(['maxTime' => $maxTime]);

        return $this;
    }
}
