<?php

declare(strict_types=1);

namespace MSML\Blueprint\Contracts;

use Spatie\LaravelData\Data;
use MSML\Blueprint\DSL\Schema\BlueprintSchema;

interface Blueprint
{
    /**
     * Build the blueprint schema with optional data for defaults.
     *
     * @param  Data|array<string,mixed>|null  $data
     */
    public function build(array|Data|null $data = null): BlueprintSchema;
}
