<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithColor;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Nodes\SegmentedControlNode;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasStringValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithOrientation;
use MSML\Blueprint\DSL\Traits\Specialized\WithSegmentedControlProps;

final class SegmentedControlBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasStringValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithColor;
    use WithDisabled;
    use WithHelp;
    use WithOrientation;
    use WithRules;
    use WithSegmentedControlProps;
    use WithSize;

    protected SegmentedControlNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;
        $this->node = new SegmentedControlNode(
            label: $label,
            data: null,
            span: 12,
            size: Size::SM,
            color: null,
            radius: null,
            disabled: false,
            readOnly: false,
            fullWidth: false,
            inline: false,
            help: null,
            withItemsBorders: true
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
