<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class RepeaterNode extends FieldNode
{
    /**
     * @param  array<string,array<string,mixed>>  $fields
     * @param  list<string>  $summaryFields
     * @param  list<string>  $actions
     * @param  list<array<string,mixed>>|null  $items
     */
    public function __construct(
        public readonly string|null $label,
        public readonly array $fields = [],
        public readonly array $summaryFields = [],
        public readonly array $actions = ['edit', 'delete'],
        public readonly string $addButtonText = 'Add new item',
        public readonly int|null $minItems = null,
        public readonly int|null $maxItems = null,
        public readonly array|null $items = null,
        public readonly int $span = 12,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
    ) {
        parent::__construct('Repeater');
    }

    /**
     * @return array<string, list<string>>
     */
    public static function rules(): array
    {
        return [
            'fields'        => ['array'],
            'summaryFields' => ['array'],
            'actions'       => ['array'],
        ];
    }
}
