<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Core;

use MSML\Blueprint\DSL\Nodes\FieldNode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Builders\RowBuilder;
use MSML\Blueprint\DSL\Builders\TabBuilder;
use MSML\Blueprint\DSL\Builders\PanelBuilder;
use MSML\Blueprint\DSL\Builders\FieldsetBuilder;

trait CoreBuilderMethods
{
    protected BlueprintCompiler $root;

    protected int $sectionIndex;

    protected int $rowIndex;

    protected string $key;

    protected FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context;

    public function default(mixed $value): self
    {
        $this->root->defaults[$this->key] = $value;

        return $this;
    }

    public function getNode(): FieldNode
    {
        return $this->node;
    }
}
