<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

use MSML\Blueprint\DSL\Enums\HorizontalPosition;

trait WithCheckboxProps
{
    public function indeterminate(bool $indeterminate = true): self
    {
        $this->updateNodeWith(['indeterminate' => $indeterminate]);

        return $this;
    }

    public function color(string $color): self
    {
        $this->updateNodeWith(['color' => $color]);

        return $this;
    }

    public function labelPosition(HorizontalPosition $position): self
    {
        $this->updateNodeWith(['labelPosition' => $position]);

        return $this;
    }

    public function labelLeft(): self
    {
        $this->updateNodeWith(['labelPosition' => HorizontalPosition::Left]);

        return $this;
    }

    public function labelRight(): self
    {
        $this->updateNodeWith(['labelPosition' => HorizontalPosition::Right]);

        return $this;
    }

    public function autoContrast(bool $autoContrast = true): self
    {
        $this->updateNodeWith(['autoContrast' => $autoContrast]);

        return $this;
    }

    public function iconColor(string $color): self
    {
        $this->updateNodeWith(['iconColor' => $color]);

        return $this;
    }

    public function radius(string $radius): self
    {
        $this->updateNodeWith(['radius' => $radius]);

        return $this;
    }
}
