<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithDatePickerProps
{
    public function clearable(bool $clearable = true): self
    {
        $this->updateNodeWith(['clearable' => $clearable]);

        return $this;
    }

    public function firstDayOfWeek(int $day): self
    {
        if ($day < 0 || $day > 6) {
            throw new \InvalidArgumentException('First day of week must be between 0 (Sunday) and 6 (Saturday)');
        }

        $this->updateNodeWith(['firstDayOfWeek' => $day]);

        return $this;
    }

    public function hideOutsideDates(bool $hide = true): self
    {
        $this->updateNodeWith(['hideOutsideDates' => $hide]);

        return $this;
    }

    public function highlightToday(bool $highlight = true): self
    {
        $this->updateNodeWith(['highlightToday' => $highlight]);

        return $this;
    }
}
