<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithSearchable
{
    public function searchable(bool $searchable = true): self
    {
        $this->updateNodeWith(['searchable' => $searchable]);

        return $this;
    }

    public function creatable(bool $creatable = true): self
    {
        $this->updateNodeWith(['creatable' => $creatable]);

        return $this;
    }
}
