<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithUpload
{
    public function uploadEndpoint(string $url): self
    {
        $this->updateNodeWith(['uploadEndpoint' => $url]);

        return $this;
    }

    public function namespace(string $namespace): self
    {
        $this->updateNodeWith(['namespace' => $namespace]);

        return $this;
    }

    public function collection(string $collection): self
    {
        $this->updateNodeWith(['collection' => $collection]);

        return $this;
    }

    public function allowBrowse(bool $allow = true): self
    {
        $this->updateNodeWith(['allowBrowse' => $allow]);

        return $this;
    }
}
