<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Enums\HorizontalPosition;

final class CheckboxNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly string|null $text = null,
        public readonly string|null $help = null,
        public readonly HorizontalPosition $labelPosition = HorizontalPosition::Right,
        public readonly Size $size = Size::SM,
        public readonly bool $indeterminate = false,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly string|null $color = null,
        public readonly bool $autoContrast = false,
        public readonly string|null $iconColor = null,
        public readonly string|null $radius = null,
    ) {
        parent::__construct('Checkbox');
    }
}
