<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Enums\ClampBehavior;

final class NumberNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly float|null $min = null,
        public readonly float|null $max = null,
        public readonly int|null $precision = null,
        public readonly float|null $step = null,
        public readonly string|null $placeholder = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $allowNegative = true,
        public readonly bool $allowDecimal = true,
        public readonly string|null $prefix = null,
        public readonly string|null $suffix = null,
        public readonly ClampBehavior|null $clampBehavior = null,
        public readonly bool $hideControls = false,
        public readonly string|null $thousandSeparator = null,
        public readonly bool $fixedDecimalScale = false,
        public readonly int|null $decimalScale = null,
    ) {
        parent::__construct('Number');
    }
}
