<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

final class SlotNode extends FieldNode
{
    /**
     * @param  array<string,mixed>  $meta
     */
    public function __construct(
        public readonly mixed $data = null,
        public readonly array|null $meta = [],
        public readonly int|null $span = 12,
    ) {
        parent::__construct('Slot');
    }

    /**
     * @return array<string, list<string>>
     */
    public static function rules(): array
    {
        return [
            'data' => ['nullable'],
            'meta' => ['array'],
        ];
    }
}
