<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class TimeInputNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly string $format = 'HH:mm',
        public readonly string|null $minTime = null,
        public readonly string|null $maxTime = null,
        public readonly string|null $placeholder = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $withSeconds = false,
    ) {
        parent::__construct('TimeInput');
    }
}
