<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Schema;

final class PanelElementSchema extends ElementSchema
{
    /** @param list<ElementSchema> $elements */
    public function __construct(
        public array $elements = [],
        int $span = 12,
        public string|null $title = null,
        public string|null $description = null,
        public bool $collapsible = false,
        public bool $defaultExpanded = true,
        public bool $bordered = true,
    ) {
        parent::__construct($span);
    }

    public function getType(): string
    {
        return 'panel';
    }
}
