<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithDateTimeBounds
{
    public function format(string $format): self
    {
        $this->updateNodeWith(['format' => $format]);

        return $this;
    }

    public function minDate(string $minDate): self
    {
        $this->updateNodeWith(['minDate' => $minDate]);

        return $this;
    }

    public function maxDate(string $maxDate): self
    {
        $this->updateNodeWith(['maxDate' => $maxDate]);

        return $this;
    }
}
