<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Nodes\SlotNode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;

final class SlotBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use NodeUpdater;
    use SpanUpdater;
    use WithRules;

    protected SlotNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new SlotNode(
            data: null,
            meta: [],
            span: 12,
        );

        $this->registerInLayout();
        $this->updateNode();
    }

    /** @param array<string,mixed> $meta **/
    public function meta(array $meta): self
    {
        $this->updateNodeWith(['meta' => $meta]);

        return $this;
    }

    public function data(callable $callback): self
    {
        $resolved = $callback();

        $this->updateNodeWith(['data' => $resolved]);

        return $this;
    }

    public function value(mixed $value): self
    {
        $this->root->defaults[$this->key] = $value;

        return $this;
    }
}
