<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL;

use MSML\Blueprint\DSL\Enums\TextInputType;
use MSML\Blueprint\DSL\Builders\DateBuilder;
use MSML\Blueprint\DSL\Builders\SlotBuilder;
use MSML\Blueprint\DSL\Builders\TagsBuilder;
use MSML\Blueprint\DSL\Builders\TextBuilder;
use MSML\Blueprint\DSL\Builders\NumberBuilder;
use MSML\Blueprint\DSL\Builders\SelectBuilder;
use MSML\Blueprint\DSL\Builders\SliderBuilder;
use MSML\Blueprint\DSL\Builders\SwitchBuilder;
use MSML\Blueprint\DSL\Builders\CheckboxBuilder;
use MSML\Blueprint\DSL\Builders\ComboboxBuilder;
use MSML\Blueprint\DSL\Builders\DropzoneBuilder;
use MSML\Blueprint\DSL\Builders\RelationBuilder;
use MSML\Blueprint\DSL\Builders\TextareaBuilder;
use MSML\Blueprint\DSL\Builders\TimeGridBuilder;
use MSML\Blueprint\DSL\Builders\DateInputBuilder;
use MSML\Blueprint\DSL\Builders\FileInputBuilder;
use MSML\Blueprint\DSL\Builders\FrequencyBuilder;
use MSML\Blueprint\DSL\Builders\TimeInputBuilder;
use MSML\Blueprint\DSL\Builders\RadioGroupBuilder;
use MSML\Blueprint\DSL\Builders\TimePickerBuilder;
use MSML\Blueprint\DSL\Builders\RangeSliderBuilder;
use MSML\Blueprint\DSL\Builders\CheckboxGroupBuilder;
use MSML\Blueprint\DSL\Builders\DateTimeInputBuilder;
use MSML\Blueprint\DSL\Builders\DateTimePickerBuilder;
use MSML\Blueprint\DSL\Builders\RichTextEditorBuilder;
use MSML\Blueprint\DSL\Builders\DateRangePickerBuilder;
use MSML\Blueprint\DSL\Builders\SegmentedControlBuilder;

trait FieldBuilderMethods
{
    abstract protected function getCompiler(): BlueprintCompiler;

    abstract protected function getSectionIndex(): int;

    abstract protected function getRowIndex(): int;

    public function text(string $key, string|null $label = null): TextBuilder
    {
        return new TextBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function email(string $key, string|null $label = null): TextBuilder
    {
        return new TextBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this,
            TextInputType::Email
        );
    }

    public function url(string $key, string|null $label = null): TextBuilder
    {
        return new TextBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this,
            TextInputType::Url
        );
    }

    public function tel(string $key, string|null $label = null): TextBuilder
    {
        return new TextBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this,
            TextInputType::Tel
        );
    }

    public function textarea(string $key, string|null $label = null): TextareaBuilder
    {
        return new TextareaBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function number(string $key, string|null $label = null): NumberBuilder
    {
        return new NumberBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function integer(string $key, string|null $label = null): NumberBuilder
    {
        $assembler = new NumberBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );

        return $assembler->precision(0);
    }

    public function float(string $key, string|null $label = null): NumberBuilder
    {
        return new NumberBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function select(string $key, string|null $label = null): SelectBuilder
    {
        return new SelectBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function radio(string $key, string|null $label = null): RadioGroupBuilder
    {
        return new RadioGroupBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function checkbox(string $key, string|null $label = null): CheckboxBuilder
    {
        return new CheckboxBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function checkboxGroup(string $key, string|null $label = null): CheckboxGroupBuilder
    {
        return new CheckboxGroupBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function boolean(string $key, string|null $label = null): CheckboxBuilder
    {
        return $this->checkbox($key, $label);
    }

    public function switch(string $key, string|null $label = null): SwitchBuilder
    {
        return new SwitchBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function date(string $key, string|null $label = null): DateInputBuilder
    {
        return new DateInputBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function datePicker(string $key, string|null $label = null): DateBuilder
    {
        return new DateBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function dateRangePicker(string $from, string $to, string|null $label = null): DateRangePickerBuilder
    {
        return new DateRangePickerBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $from,
            $to,
            $label,
            $this
        );
    }

    public function dateTime(string $key, string|null $label = null): DateTimeInputBuilder
    {
        return new DateTimeInputBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function tags(string $key, string|null $label = null): TagsBuilder
    {
        return new TagsBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function relation(string $key, string|null $label = null): RelationBuilder
    {
        return new RelationBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function autocomplete(string $key, string|null $label = null): RelationBuilder
    {
        return $this->relation($key, $label);
    }

    public function fileInput(string $key, string|null $label = null): FileInputBuilder
    {
        return new FileInputBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function file(string $key, string|null $label = null): FileInputBuilder
    {
        return $this->fileInput($key, $label);
    }

    public function dropzone(string $key, string|null $label = null): DropzoneBuilder
    {
        return new DropzoneBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function slider(string $key, string|null $label = null): SliderBuilder
    {
        return new SliderBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function rangeSlider(string $from, string $to, string|null $label = null): RangeSliderBuilder
    {
        return new RangeSliderBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $from,
            $to,
            $label,
            $this
        );
    }

    public function combobox(string $key, string|null $label = null): ComboboxBuilder
    {
        return new ComboboxBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function richText(string $key, string|null $label = null): RichTextEditorBuilder
    {
        return new RichTextEditorBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function dateTimePicker(string $key, string|null $label = null): DateTimePickerBuilder
    {
        return new DateTimePickerBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function timeInput(string $key, string|null $label = null): TimeInputBuilder
    {
        return new TimeInputBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function timePicker(string $key, string|null $label = null): TimePickerBuilder
    {
        return new TimePickerBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function timeGrid(string $key, string|null $label = null): TimeGridBuilder
    {
        return new TimeGridBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function time(string $key, string|null $label = null): TimePickerBuilder
    {
        return $this->timePicker($key, $label);
    }

    public function segmentedControl(string $key, string|null $label = null): SegmentedControlBuilder
    {
        return new SegmentedControlBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $label,
            $this
        );
    }

    public function frequencyField(string $valueKey, string $unitKey, string|null $label = null): FrequencyBuilder
    {
        return new FrequencyBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $valueKey,
            $unitKey,
            $label,
            $this
        );
    }

    public function slot(string $key): SlotBuilder
    {
        return new SlotBuilder(
            $this->getCompiler(),
            $this->getSectionIndex(),
            $this->getRowIndex(),
            $key,
            $this,
        );
    }
}
