<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class FrequencyNode extends FieldNode
{
    /**
     * @param  array<string>  $units
     */
    public function __construct(
        public readonly string $valueKey,
        public readonly string $unitKey,
        public readonly string|null $label,
        public readonly array $units,
        public readonly string|null $plainText = null,
        public readonly int $span = 12,
        public readonly float|null $min = null,
        public readonly float|null $max = null,
        public readonly float|null $step = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
    ) {
        parent::__construct('Frequency');
    }
}
