<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Enums\ResizeMode;

final class TextareaNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly string|null $placeholder = null,
        public readonly int|null $rows = null,
        public readonly int|null $maxLength = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $autosize = false,
        public readonly bool $liveCharCount = false,
        public readonly int|null $minRows = 3,
        public readonly int|null $maxRows = 10,
        public readonly ResizeMode $resize = ResizeMode::Vertical,
        public readonly string|null $iconLeft = null,
        public readonly string|null $iconRight = null,
    ) {
        parent::__construct('Textarea');
    }
}
